<?php

use Illuminate\Support\Facades\Broadcast;

/*
|--------------------------------------------------------------------------
| Broadcast Channels
|--------------------------------------------------------------------------
|
| Here you may register all of the event broadcasting channels that your
| application supports. The given channel authorization callbacks are
| used to check if an authenticated user can listen to the channel.
|
*/

// User private channel
Broadcast::channel('user.{userId}', function ($user, $userId) {
    return $user->id === $userId;
});

// Chat private channel
Broadcast::channel('chat.{chatId}', function ($user, $chatId) {
    $chat = \App\Models\Chat::find($chatId);
    return $chat && in_array($user->id, $chat->participants ?? []);
});

// Sync private channel
Broadcast::channel('sync.{syncId}', function ($user, $syncId) {
    $sync = \App\Models\Sync::with(['brand', 'creator'])->find($syncId);
    if (!$sync) return false;
    
    return ($user->isBrand() && $sync->brand->user_id === $user->id) ||
           ($user->isCreator() && $sync->creator->user_id === $user->id);
});

// Brand private channel
Broadcast::channel('brand.{brandId}', function ($user, $brandId) {
    return $user->isBrand() && $user->brandProfile?->id === $brandId;
});

// Creator private channel
Broadcast::channel('creator.{creatorId}', function ($user, $creatorId) {
    return $user->isCreator() && $user->creatorProfile?->id === $creatorId;
});
