<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Feed Posts
        Schema::create('feed_posts', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('brand_id')->nullable();
            $table->uuid('creator_id')->nullable();
            $table->uuid('sync_id')->nullable();
            $table->string('post_type');
            $table->text('content')->nullable();
            $table->json('media_urls')->default('[]');
            $table->integer('like_count')->default(0);
            $table->boolean('is_visible')->default(true);
            $table->timestamp('created_at')->useCurrent();
        });

        // Feed Likes
        Schema::create('feed_likes', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('post_id');
            $table->uuid('user_id');
            $table->timestamp('created_at')->useCurrent();

            $table->unique(['post_id', 'user_id']);
        });

        // Follows
        Schema::create('follows', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('follower_id');
            $table->uuid('following_id');
            $table->timestamp('created_at')->useCurrent();

            $table->unique(['follower_id', 'following_id']);
        });

        // App Settings
        Schema::create('app_settings', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('key')->unique();
            $table->json('value');
            $table->timestamp('updated_at')->useCurrent();
        });

        // System Config
        Schema::create('system_config', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('key')->unique();
            $table->json('value');
            $table->timestamp('updated_at')->useCurrent();
        });

        // Role Configs
        Schema::create('role_configs', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('name')->unique();
            $table->json('permissions');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('role_configs');
        Schema::dropIfExists('system_config');
        Schema::dropIfExists('app_settings');
        Schema::dropIfExists('follows');
        Schema::dropIfExists('feed_likes');
        Schema::dropIfExists('feed_posts');
    }
};
