<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admins', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('email')->unique();
            $table->string('password_hash');
            $table->string('name')->nullable();
            $table->string('role')->default('support_admin'); // AdminRole enum
            $table->boolean('is_active')->default(true);
            $table->json('permissions')->default('{}');
            $table->timestamp('last_login')->nullable();
            $table->timestamps();
        });

        Schema::create('audit_logs', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('action');
            $table->string('table_name')->nullable();
            $table->string('record_id')->nullable();
            $table->string('record_title')->nullable();
            $table->json('old_data')->nullable();
            $table->json('new_data')->nullable();
            $table->uuid('performed_by')->nullable();
            $table->timestamp('performed_at')->useCurrent();

            $table->foreign('performed_by')->references('id')->on('admins')->onDelete('set null');
        });

        Schema::create('admin_notifications', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('title');
            $table->text('body')->nullable();
            $table->string('type')->nullable();
            $table->boolean('is_read')->default(false);
            $table->json('metadata')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admin_notifications');
        Schema::dropIfExists('audit_logs');
        Schema::dropIfExists('admins');
    }
};
