<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chats', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('sync_id')->unique()->nullable();
            $table->json('participants')->default('[]');
            $table->timestamp('last_message_at')->nullable();
            $table->timestamp('created_at')->useCurrent();

            $table->foreign('sync_id')->references('id')->on('syncs')->onDelete('set null');
        });

        Schema::create('messages', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('chat_id')->constrained('chats')->onDelete('cascade');
            $table->foreignUuid('sender_id')->constrained('users');
            $table->text('content')->nullable();
            $table->string('message_type')->default('text'); // MessageType enum
            $table->json('attachments')->default('[]');
            $table->json('read_by')->default('[]');
            $table->timestamp('created_at')->useCurrent();

            $table->index('chat_id');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('messages');
        Schema::dropIfExists('chats');
    }
};
