<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('syncs', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('campaign_id')->constrained('campaigns')->onDelete('cascade');
            $table->foreignUuid('brand_id')->constrained('brand_profiles');
            $table->foreignUuid('creator_id')->constrained('creator_profiles');
            $table->string('status')->default('applied'); // SyncStatus enum
            $table->decimal('agreed_amount', 12, 2)->nullable();
            $table->json('content_types')->default('[]');
            $table->timestamp('deadline')->nullable();
            $table->json('submissions')->default('[]');
            $table->json('milestones')->default('[]');
            $table->decimal('paid_amount', 12, 2)->default(0);
            $table->uuid('chat_id')->unique()->nullable();
            $table->string('contract_url')->nullable();
            $table->timestamp('payment_held_date')->nullable();
            $table->timestamp('payment_released_date')->nullable();
            $table->timestamps();

            $table->index('status');
            $table->index('campaign_id');
            $table->index('creator_id');
            $table->index('brand_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('syncs');
    }
};
