<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('campaigns', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('brand_id')->constrained('brand_profiles')->onDelete('cascade');
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('cover_image')->nullable();
            $table->json('content_types')->default('[]');
            $table->json('target_niches')->default('[]');
            $table->json('follower_ranges')->default('[]');
            $table->json('preferred_languages')->default('[]');
            $table->decimal('budget', 12, 2)->nullable();
            $table->string('payment_type')->default('fixed'); // PaymentType enum
            $table->integer('max_creators')->nullable();
            $table->timestamp('deadline')->nullable();
            $table->string('status')->default('draft'); // CampaignStatus enum
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_hot')->default(false);
            $table->json('requirements')->default('[]');
            $table->json('deliverables')->nullable();
            $table->integer('applications_count')->default(0);
            $table->integer('hired_count')->default(0);
            $table->decimal('spent', 12, 2)->default(0);
            // Denormalized fields for performance
            $table->string('brand_name')->nullable();
            $table->string('brand_logo')->nullable();
            $table->timestamps();

            $table->index('status');
            $table->index(['is_featured', 'is_hot']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('campaigns');
    }
};
