<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('creator_profiles', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('user_id')->unique()->constrained('users')->onDelete('cascade');
            $table->string('display_name');
            $table->text('bio')->nullable();
            $table->string('profile_image_url')->nullable();
            $table->string('location')->nullable();
            $table->json('niches')->default('[]');
            $table->string('availability')->default('available'); // CreatorAvailability enum
            $table->boolean('is_top_creator')->default(false);
            $table->boolean('is_verified')->default(false);
            $table->json('social_links')->default('[]');
            $table->json('rate_card')->default('[]');
            $table->json('portfolio')->default('[]');
            $table->decimal('wallet_balance', 12, 2)->default(0);
            $table->decimal('total_earnings', 12, 2)->default(0);
            $table->decimal('rating', 3, 2)->default(0);
            $table->integer('total_reviews')->default(0);
            $table->integer('total_syncs')->default(0);
            $table->decimal('completion_rate', 5, 2)->default(0);
            $table->integer('profile_completion')->default(0);
            $table->timestamps();
        });

        Schema::create('creator_transactions', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('creator_id')->constrained('creator_profiles')->onDelete('cascade');
            $table->decimal('amount', 12, 2);
            $table->boolean('is_credit');
            $table->string('type'); // TransactionType enum
            $table->string('status')->default('pending'); // TransactionStatus enum
            $table->string('reference_id')->nullable();
            $table->text('description')->nullable();
            $table->json('metadata')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });

        Schema::create('creator_notifications', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('creator_id')->constrained('creator_profiles')->onDelete('cascade');
            $table->string('title');
            $table->text('body')->nullable();
            $table->string('category')->nullable();
            $table->string('type')->nullable();
            $table->boolean('is_read')->default(false);
            $table->json('metadata')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('creator_notifications');
        Schema::dropIfExists('creator_transactions');
        Schema::dropIfExists('creator_profiles');
    }
};
