<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('brand_profiles', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('user_id')->unique()->constrained('users')->onDelete('cascade');
            $table->string('company_name');
            $table->string('logo')->nullable();
            $table->string('website')->nullable();
            $table->text('description')->nullable();
            $table->string('industry')->nullable();
            $table->json('target_niches')->default('[]');
            $table->string('budget_range')->nullable();
            $table->boolean('is_verified')->default(false);
            $table->string('contact_email')->nullable();
            $table->string('contact_phone')->nullable();
            $table->string('location')->nullable();
            $table->json('team_members')->default('[]');
            $table->decimal('wallet_balance', 12, 2)->default(0);
            $table->decimal('total_spent', 12, 2)->default(0);
            $table->integer('total_campaigns')->default(0);
            $table->integer('active_campaigns')->default(0);
            $table->integer('total_creators_worked_with')->default(0);
            $table->integer('profile_completion')->default(0);
            $table->timestamps();
        });

        Schema::create('brand_transactions', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('brand_id')->constrained('brand_profiles')->onDelete('cascade');
            $table->decimal('amount', 12, 2);
            $table->boolean('is_credit');
            $table->string('type'); // TransactionType enum
            $table->string('status')->default('pending'); // TransactionStatus enum
            $table->string('reference_id')->nullable();
            $table->text('description')->nullable();
            $table->json('metadata')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });

        Schema::create('brand_notifications', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('brand_id')->constrained('brand_profiles')->onDelete('cascade');
            $table->string('title');
            $table->text('body')->nullable();
            $table->string('category')->nullable();
            $table->string('type')->nullable();
            $table->boolean('is_read')->default(false);
            $table->json('metadata')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('brand_notifications');
        Schema::dropIfExists('brand_transactions');
        Schema::dropIfExists('brand_profiles');
    }
};
