<?php

namespace Database\Factories;

use App\Enums\CreatorAvailability;
use App\Models\CreatorProfile;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\CreatorProfile>
 */
class CreatorProfileFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'display_name' => fake()->userName(),
            'bio' => fake()->paragraph(),
            'profile_image_url' => fake()->imageUrl(200, 200, 'people'),
            'location' => fake()->city() . ', ' . fake()->country(),
            'niches' => fake()->randomElements(['Fashion', 'Beauty', 'Tech', 'Food', 'Travel', 'Gaming'], 3),
            'availability' => fake()->randomElement(CreatorAvailability::cases()),
            'rating' => fake()->randomFloat(1, 4, 5),
            'wallet_balance' => fake()->numberBetween(100, 5000),
            'total_earnings' => fake()->numberBetween(1000, 20000),
            'total_reviews' => fake()->numberBetween(5, 50),
            'is_verified' => fake()->boolean(20),
            'is_top_creator' => fake()->boolean(10),
            'profile_completion' => fake()->numberBetween(80, 100),
            'social_links' => [
                'instagram' => 'https://instagram.com/' . fake()->userName(),
                'youtube' => 'https://youtube.com/' . fake()->userName(),
            ],
            'rate_card' => [
                ['content_type' => 'Reel', 'price' => fake()->numberBetween(100, 500)],
                ['content_type' => 'Story', 'price' => fake()->numberBetween(50, 200)],
            ],
            'portfolio' => [
                ['type' => 'image', 'url' => fake()->imageUrl(), 'title' => 'Sample Work'],
            ],
        ];
    }
}
