<?php

namespace Database\Factories;

use App\Enums\CampaignStatus;
use App\Enums\PaymentType;
use App\Models\BrandProfile;
use App\Models\Campaign;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Campaign>
 */
class CampaignFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'brand_id' => BrandProfile::factory(),
            'title' => fake()->catchPhrase(),
            'description' => fake()->paragraphs(3, true),
            'cover_image' => fake()->imageUrl(800, 400, 'nature'),
            'content_types' => ['Instagram Reel', 'Instagram Story'],
            'status' => fake()->randomElement(CampaignStatus::cases()),
            'target_niches' => fake()->randomElements(['Fashion', 'Beauty', 'Tech', 'Food'], 2),
            'budget' => fake()->numberBetween(100, 1000),
            'payment_type' => fake()->randomElement(PaymentType::cases()),
            'max_creators' => fake()->numberBetween(1, 10),
            'deadline' => fake()->dateTimeBetween('now', '+1 month'),
            'is_featured' => fake()->boolean(10),
            'is_hot' => fake()->boolean(5),
            'requirements' => ['1 Post', '2 Stories'],
            'deliverables' => ['Reel', 'Story'],
            'applications_count' => fake()->numberBetween(0, 5),
            'hired_count' => fake()->numberBetween(0, 2),
        ];
    }
}
