<?php

namespace Database\Factories;

use App\Models\BrandProfile;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\BrandProfile>
 */
class BrandProfileFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'company_name' => fake()->company(),
            'logo' => fake()->imageUrl(200, 200, 'business'),
            'website' => fake()->url(),
            'description' => fake()->paragraph(),
            'industry' => fake()->randomElement(['Fashion', 'Tech', 'Food', 'Travel', 'Health']),
            'target_niches' => fake()->randomElements(['Fashion', 'Beauty', 'Tech', 'Food', 'Travel'], 2),
            'budget_range' => fake()->randomElement(['$1k-5k', '$5k-10k', '$10k+']),
            'wallet_balance' => fake()->numberBetween(1000, 50000),
            'location' => fake()->city() . ', ' . fake()->country(),
            'is_verified' => fake()->boolean(30),
            'profile_completion' => fake()->numberBetween(50, 100),
        ];
    }
}
