<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class FeedPost extends Model
{
    use HasUuids;

    protected $keyType = 'string';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'brand_id',
        'creator_id',
        'sync_id',
        'post_type',
        'content',
        'media_urls',
        'like_count',
        'is_visible',
    ];

    protected function casts(): array
    {
        return [
            'media_urls' => 'array',
            'is_visible' => 'boolean',
            'created_at' => 'datetime',
        ];
    }

    public function scopeVisible($query)
    {
        return $query->where('is_visible', true);
    }
}
