<?php

namespace App\Models;

use App\Enums\CreatorAvailability;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CreatorProfile extends Model
{
    use HasFactory, HasUuids;

    protected $keyType = 'string';
    public $incrementing = false;

    protected $fillable = [
        'user_id',
        'display_name',
        'bio',
        'profile_image_url',
        'location',
        'niches',
        'availability',
        'is_top_creator',
        'is_verified',
        'social_links',
        'rate_card',
        'portfolio',
        'wallet_balance',
        'total_earnings',
        'rating',
        'total_reviews',
        'total_syncs',
        'completion_rate',
        'profile_completion',
    ];

    protected function casts(): array
    {
        return [
            'niches' => 'array',
            'social_links' => 'array',
            'rate_card' => 'array',
            'portfolio' => 'array',
            'availability' => CreatorAvailability::class,
            'is_top_creator' => 'boolean',
            'is_verified' => 'boolean',
            'wallet_balance' => 'decimal:2',
            'total_earnings' => 'decimal:2',
            'rating' => 'decimal:2',
            'completion_rate' => 'decimal:2',
        ];
    }

    // Relationships
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function syncs(): HasMany
    {
        return $this->hasMany(Sync::class, 'creator_id');
    }

    public function transactions(): HasMany
    {
        return $this->hasMany(CreatorTransaction::class, 'creator_id');
    }

    public function notifications(): HasMany
    {
        return $this->hasMany(CreatorNotification::class, 'creator_id');
    }
}
