<?php

namespace App\Models;

use App\Enums\CampaignStatus;
use App\Enums\PaymentType;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Campaign extends Model
{
    use HasFactory, HasUuids;

    protected $keyType = 'string';
    public $incrementing = false;

    protected $fillable = [
        'brand_id',
        'title',
        'description',
        'cover_image',
        'content_types',
        'target_niches',
        'follower_ranges',
        'preferred_languages',
        'budget',
        'payment_type',
        'max_creators',
        'deadline',
        'status',
        'is_featured',
        'is_hot',
        'requirements',
        'deliverables',
        'applications_count',
        'hired_count',
        'spent',
        'brand_name',
        'brand_logo',
    ];

    protected function casts(): array
    {
        return [
            'content_types' => 'array',
            'target_niches' => 'array',
            'follower_ranges' => 'array',
            'preferred_languages' => 'array',
            'requirements' => 'array',
            'deliverables' => 'array',
            'budget' => 'decimal:2',
            'spent' => 'decimal:2',
            'payment_type' => PaymentType::class,
            'status' => CampaignStatus::class,
            'is_featured' => 'boolean',
            'is_hot' => 'boolean',
            'deadline' => 'datetime',
        ];
    }

    // Relationships
    public function brand(): BelongsTo
    {
        return $this->belongsTo(BrandProfile::class, 'brand_id');
    }

    public function syncs(): HasMany
    {
        return $this->hasMany(Sync::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('status', CampaignStatus::ACTIVE);
    }

    public function scopeFeatured($query)
    {
        return $query->where('is_featured', true)->orWhere('is_hot', true);
    }
}
