<?php

namespace App\Models;

use App\Enums\TransactionStatus;
use App\Enums\TransactionType;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BrandProfile extends Model
{
    use HasFactory, HasUuids;

    protected $keyType = 'string';
    public $incrementing = false;

    protected $fillable = [
        'user_id',
        'company_name',
        'logo',
        'website',
        'description',
        'industry',
        'target_niches',
        'budget_range',
        'is_verified',
        'contact_email',
        'contact_phone',
        'location',
        'team_members',
        'wallet_balance',
        'total_spent',
        'total_campaigns',
        'active_campaigns',
        'total_creators_worked_with',
        'profile_completion',
    ];

    protected function casts(): array
    {
        return [
            'target_niches' => 'array',
            'team_members' => 'array',
            'is_verified' => 'boolean',
            'wallet_balance' => 'decimal:2',
            'total_spent' => 'decimal:2',
        ];
    }

    // Relationships
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function campaigns(): HasMany
    {
        return $this->hasMany(Campaign::class, 'brand_id');
    }

    public function syncs(): HasMany
    {
        return $this->hasMany(Sync::class, 'brand_id');
    }

    public function transactions(): HasMany
    {
        return $this->hasMany(BrandTransaction::class, 'brand_id');
    }

    public function notifications(): HasMany
    {
        return $this->hasMany(BrandNotification::class, 'brand_id');
    }
}
