<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'id' => $this->id,
            'phone' => $this->phone,
            'email' => $this->email,
            'role' => $this->role,
            'createdAt' => $this->created_at->toIsoString(),
            'updatedAt' => $this->updated_at->toIsoString(),
            'fcmToken' => $this->fcm_token,
        ];

        // Merge profile data if loaded
        if ($this->relationLoaded('brandProfile') && $this->brandProfile) {
            $data['isVerified'] = (bool) $this->brandProfile->is_verified;
            // Add other brand fields if needed
        } elseif ($this->relationLoaded('creatorProfile') && $this->creatorProfile) {
            $data['isVerified'] = (bool) $this->creatorProfile->is_verified;
            $data['isOnboardingComplete'] = (bool) $this->creatorProfile->is_onboarding_complete;
             // Add other creator fields if needed
        }

        return $data;
    }
}
