<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SyncResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'campaignId' => $this->campaign_id,
            'brandId' => $this->brand_id,
            'creatorId' => $this->creator_id,
            'status' => $this->status,
            'contentTypes' => $this->content_types,
            'deliverables' => $this->deliverables,
            'createdAt' => $this->created_at->toIsoString(),
            'updatedAt' => $this->updated_at->toIsoString(),
            'campaign' => new CampaignResource($this->whenLoaded('campaign')),
            'brand' => new BrandResource($this->whenLoaded('brand')),
            'creator' => new CreatorResource($this->whenLoaded('creator')),
        ];
    }
}
