<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DisputeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'syncId' => $this->sync_id,
            'openedBy' => $this->opened_by,
            'reason' => $this->reason,
            'description' => $this->description,
            'status' => $this->status,
            'resolution' => $this->resolution,
            'resolvedBy' => $this->resolved_by,
            'resolvedAt' => $this->resolved_at?->toIsoString(),
            'createdAt' => $this->created_at->toIsoString(),
            'updatedAt' => $this->updated_at->toIsoString(),
            'sync' => new SyncResource($this->whenLoaded('sync')),
        ];
    }
}
