<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CreatorResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'userId' => $this->user_id,
            'displayName' => $this->display_name,
            'bio' => $this->bio,
            'profileImageUrl' => $this->profile_image_url,
            'location' => $this->location,
            'niches' => $this->niches,
            'availability' => $this->availability,
            'isTopCreator' => (bool) $this->is_top_creator,
            'isVerified' => (bool) $this->is_verified,
            'socialLinks' => $this->social_links,
            'rateCard' => $this->rate_card,
            'portfolio' => $this->portfolio,
            'walletBalance' => (float) $this->wallet_balance,
            'totalEarnings' => (float) $this->total_earnings,
            'rating' => (float) $this->rating,
            'totalReviews' => (int) $this->total_reviews,
            'totalSyncs' => (int) $this->total_syncs,
            'completionRate' => (float) $this->completion_rate,
            'profileCompletion' => (int) $this->profile_completion,
            'createdAt' => $this->created_at->toIsoString(),
            'updatedAt' => $this->updated_at->toIsoString(),
            'user' => $this->whenLoaded('user', function () {
                return [
                    'email' => $this->user->email,
                    'phone' => $this->user->phone,
                ];
            }),
        ];
    }
}
