<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CampaignResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'brandId' => $this->brand_id,
            'title' => $this->title,
            'description' => $this->description,
            'coverImage' => $this->cover_image,
            'contentTypes' => $this->content_types,
            'targetNiches' => $this->target_niches,
            'followerRanges' => $this->follower_ranges,
            'preferredLanguages' => $this->preferred_languages,
            'budget' => (float) $this->budget,
            'paymentType' => $this->payment_type,
            'maxCreators' => $this->max_creators,
            'deadline' => $this->deadline?->toIsoString(),
            'status' => $this->status,
            'isFeatured' => (bool) $this->is_featured,
            'isHot' => (bool) $this->is_hot,
            'requirements' => $this->requirements,
            'deliverables' => $this->deliverables,
            'applicationsCount' => (int) $this->applications_count,
            'hiredCount' => (int) $this->hired_count,
            'spent' => (float) $this->spent,
            'brandName' => $this->brand_name,
            'brandLogo' => $this->brand_logo,
            'createdAt' => $this->created_at->toIsoString(),
            'updatedAt' => $this->updated_at->toIsoString(),
            'brand' => new BrandResource($this->whenLoaded('brand')),
        ];
    }
}
