<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BrandResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'userId' => $this->user_id,
            'companyName' => $this->company_name,
            'logo' => $this->logo,
            'website' => $this->website,
            'description' => $this->description,
            'industry' => $this->industry,
            'targetNiches' => $this->target_niches,
            'budgetRange' => $this->budget_range,
            'isVerified' => (bool) $this->is_verified,
            'contactEmail' => $this->contact_email,
            'contactPhone' => $this->contact_phone,
            'location' => $this->location,
            'teamMembers' => $this->team_members,
            'walletBalance' => (float) $this->wallet_balance,
            'totalSpent' => (float) $this->total_spent,
            'totalCampaigns' => (int) $this->total_campaigns,
            'activeCampaigns' => (int) $this->active_campaigns,
            'totalCreatorsWorkedWith' => (int) $this->total_creators_worked_with,
            'profileCompletion' => (int) $this->profile_completion,
            'createdAt' => $this->created_at->toIsoString(),
            'updatedAt' => $this->updated_at->toIsoString(),
            'user' => $this->whenLoaded('user', function () {
                return [
                    'email' => $this->user->email,
                    'phone' => $this->user->phone,
                    'isVerified' => (bool) $this->user->is_verified,
                ];
            }),
        ];
    }
}
