<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AuditLogResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'adminId' => $this->admin_id,
            'targetType' => $this->target_type,
            'targetId' => $this->target_id,
            'action' => $this->action,
            'details' => $this->details,
            'ipAddress' => $this->ip_address,
            'userAgent' => $this->user_agent,
            'performedAt' => $this->performed_at->toIsoString(),
            'admin' => new AdminResource($this->whenLoaded('admin')),
        ];
    }
}
