<?php

namespace App\Http\Middleware;

use App\Models\Admin;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminAuthenticate
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next, ?string $role = null): Response
    {
        $admin = $request->user('admin');

        if (!$admin || !$admin instanceof Admin) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }

        if (!$admin->is_active) {
            return response()->json(['error' => 'Account deactivated'], 403);
        }

        // Check role if specified
        if ($role && !$this->hasRole($admin, $role)) {
            return response()->json(['error' => 'Insufficient permissions'], 403);
        }

        return $next($request);
    }

    private function hasRole(Admin $admin, string $role): bool
    {
        return match ($role) {
            'super_admin' => $admin->isSuperAdmin(),
            'finance_admin' => $admin->isFinanceAdmin(),
            default => true,
        };
    }
}
