<?php

namespace App\Events;

use App\Enums\SyncStatus;
use App\Models\Sync;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SyncStatusUpdated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Sync $sync;
    public string $previousStatus;

    public function __construct(Sync $sync, string $previousStatus)
    {
        $this->sync = $sync;
        $this->previousStatus = $previousStatus;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('sync.' . $this->sync->id),
            new PrivateChannel('brand.' . $this->sync->brand_id),
            new PrivateChannel('creator.' . $this->sync->creator_id),
        ];
    }

    /**
     * The event's broadcast name.
     */
    public function broadcastAs(): string
    {
        return 'sync.status.updated';
    }

    /**
     * Get the data to broadcast.
     *
     * @return array<string, mixed>
     */
    public function broadcastWith(): array
    {
        return [
            'sync_id' => $this->sync->id,
            'campaign_id' => $this->sync->campaign_id,
            'previous_status' => $this->previousStatus,
            'new_status' => $this->sync->status,
            'updated_at' => $this->sync->updated_at?->toISOString(),
        ];
    }
}
